/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.pi.PICodActions;
import com.ibm.hsc.cim.client.pi.PIHSCCECCIMClient;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PICodMemInfoDataBean;
import com.ibm.hsc.client.PICodOrderInfoDataBean;
import com.ibm.hsc.client.PICodProcInfoDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIOnoffCodBillingInfoDataBean;
import com.ibm.hsc.client.PISharedProcPoolUtilizationDataBean;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PICodList {
    private static final int NUM_VALID_PARMS = 7;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_codType;
    private String m_listType;
    private String m_format;
    private boolean m_header;
    private boolean m_all;
    private HashMap m_validParms = new HashMap(15, 0.5f);
    private PIHSCCECClient m_CECClient = null;
    private PICodActions m_codClient = null;
    private String m_delimiter = ",";
    private PrintStream m_out;
    private boolean m_writeStatus;
    private static final String LIST_BILLING = "bill";
    private static final String LIST_CAPACITY = "cap";
    private static final String LIST_HISTORY = "hist";
    private static final String LIST_CODE = "code";
    private static final String LIST_UTILIZATION = "util";
    private static final String UNRETURNED_TRIAL_PROCS_IN_USE_MSG_ID = "0017";
    private static final String UNRETURNED_TRIAL_MEM_IN_USE_MSG_ID = "0018";

    private PICodList(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-c", null);
        this.m_validParms.put("-t", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
        this.m_validParms.put("--all", null);
    }

    private void doBillingList() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = "proc".equals(this.m_resourceType) ? (this.m_all ? PIOnoffCodBillingInfoDataBean.ALL_ELECTRONIC_BILLING_PROC_KEYS : PIOnoffCodBillingInfoDataBean.ALL_PROC_KEYS) : (this.m_all ? PIOnoffCodBillingInfoDataBean.ALL_ELECTRONIC_BILLING_MEM_KEYS : PIOnoffCodBillingInfoDataBean.ALL_MEM_KEYS);
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        PIOnoffCodBillingInfoDataBean pIOnoffCodBillingInfoDataBean = "proc".equals(this.m_resourceType) ? this.m_codClient.getOnoffCodProcBillingInfoDataBean() : this.m_codClient.getOnoffCodMemBillingInfoDataBean();
        Vector<PIOnoffCodBillingInfoDataBean> vector = new Vector<PIOnoffCodBillingInfoDataBean>();
        vector.addElement(pIOnoffCodBillingInfoDataBean);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doProcCapacityList() throws PIHscClientException {
        int n;
        String[] stringArray;
        String[] stringArray2 = "cuod".equals(this.m_codType) ? new String[]{"perm_procs"} : ("onoff".equals(this.m_codType) ? new String[]{"proc_onoff_state", "activated_onoff_procs", "avail_procs_for_onoff", "unreturned_onoff_procs", "onoff_request_proc_days_left", "onoff_proc_day_hours_left", "onoff_proc_days_avail"} : ("trial".equals(this.m_codType) ? new String[]{"proc_trial_state", "activated_trial_procs", "proc_trial_days_left", "proc_trial_hours_left"} : new String[]{"proc_reserve_state", "activated_reserve_procs", "avail_procs_for_reserve", "reserve_prepaid_proc_days_left", "reserve_procs_hours_left"}));
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        PICodProcInfoDataBean pICodProcInfoDataBean = this.m_codClient.getCodProcInfoDataBean(stringArray);
        if ("trial".equals(this.m_codType) && (n = pICodProcInfoDataBean.getTrialProcsUnreturned().intValue()) != 0) {
            String[] stringArray3 = new String[]{String.valueOf(n)};
            throw new PIHscClientException("8000", "CoDMsgBundle", UNRETURNED_TRIAL_PROCS_IN_USE_MSG_ID, stringArray3, null);
        }
        Vector<PICodProcInfoDataBean> vector = new Vector<PICodProcInfoDataBean>();
        vector.addElement(pICodProcInfoDataBean);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doMemCapacityList() throws PIHscClientException {
        int n;
        String[] stringArray;
        String[] stringArray2 = "cuod".equals(this.m_codType) ? new String[]{"perm_mem"} : ("onoff".equals(this.m_codType) ? new String[]{"mem_onoff_state", "activated_onoff_mem", "avail_mem_for_onoff", "unreturned_onoff_mem", "onoff_request_mem_days_left", "onoff_mem_day_hours_left", "onoff_mem_days_avail"} : new String[]{"mem_trial_state", "activated_trial_mem", "mem_trial_days_left", "mem_trial_hours_left"});
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        PICodMemInfoDataBean pICodMemInfoDataBean = this.m_codClient.getCodMemInfoDataBean(stringArray);
        if ("trial".equals(this.m_codType) && (n = pICodMemInfoDataBean.getTrialMemUnreturned().intValue()) != 0) {
            String[] stringArray3 = new String[]{String.valueOf(n / 1024)};
            throw new PIHscClientException("8000", "CoDMsgBundle", UNRETURNED_TRIAL_MEM_IN_USE_MSG_ID, stringArray3, null);
        }
        Vector<PICodMemInfoDataBean> vector = new Vector<PICodMemInfoDataBean>();
        vector.addElement(pICodMemInfoDataBean);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doHistoryList() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"time_stamp", "entry"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector vector = this.m_codClient.getCodHistoryLog();
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doCodeInfoList() throws PIHscClientException {
        String[] stringArray;
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, PICodOrderInfoDataBean.ALL_KEYS, PICodOrderInfoDataBean.ALL_KEYS.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(PICodOrderInfoDataBean.ALL_KEYS, this.m_format, this.m_delimiter);
        } else {
            stringArray = PICodOrderInfoDataBean.ALL_KEYS;
        }
        int n = "cuod".equals(this.m_codType) ? 1 : ("onoff".equals(this.m_codType) ? 2 : ("reserve".equals(this.m_codType) ? 3 : ("trialexc".equals(this.m_codType) ? 5 : 4)));
        int n2 = "proc".equals(this.m_resourceType) ? 1 : 2;
        PICodOrderInfoDataBean pICodOrderInfoDataBean = this.m_codClient.getCodOrderInfoDataBean(n, n2);
        Vector<PICodOrderInfoDataBean> vector = new Vector<PICodOrderInfoDataBean>();
        vector.addElement(pICodOrderInfoDataBean);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doUtilizationList() throws PIHscClientException {
        String[] stringArray;
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, PISharedProcPoolUtilizationDataBean.ALL_KEYS, PISharedProcPoolUtilizationDataBean.ALL_KEYS.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(PISharedProcPoolUtilizationDataBean.ALL_KEYS, this.m_format, this.m_delimiter);
        } else {
            stringArray = PISharedProcPoolUtilizationDataBean.ALL_KEYS;
        }
        PISharedProcPoolUtilizationDataBean pISharedProcPoolUtilizationDataBean = this.m_codClient.getSharedProcPoolUtilizationDataBean(stringArray);
        Vector<PISharedProcPoolUtilizationDataBean> vector = new Vector<PISharedProcPoolUtilizationDataBean>();
        vector.addElement(pISharedProcPoolUtilizationDataBean);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state", "hyp_capabilities"});
        int n = pICECDataBean.getCecState().intValue();
        if (n != 17 && n != 1 && n != 16) {
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
        }
        if (!pICECDataBean.isCUoDCapable()) {
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9000", null, null);
        }
        this.m_codClient = PICodActions.getInstance((PIHSCCECCIMClient)this.m_CECClient);
        if (LIST_BILLING.equals(this.m_listType)) {
            this.doBillingList();
        } else if (LIST_CAPACITY.equals(this.m_listType)) {
            if ("proc".equals(this.m_resourceType)) {
                this.doProcCapacityList();
            } else {
                this.doMemCapacityList();
            }
        } else if (LIST_HISTORY.equals(this.m_listType)) {
            this.doHistoryList();
        } else if (LIST_CODE.equals(this.m_listType)) {
            this.doCodeInfoList();
        } else {
            this.doUtilizationList();
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (!(this.m_listType != null && (LIST_BILLING.equals(this.m_listType) || LIST_CAPACITY.equals(this.m_listType) || LIST_HISTORY.equals(this.m_listType) || LIST_CODE.equals(this.m_listType) || LIST_UTILIZATION.equals(this.m_listType)))) {
            string = string + ", -t";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (LIST_CAPACITY.equals(this.m_listType) || LIST_CODE.equals(this.m_listType)) {
            if (LIST_CAPACITY.equals(this.m_listType)) {
                if (this.m_codType == null || !"onoff".equals(this.m_codType) && !"cuod".equals(this.m_codType) && !"reserve".equals(this.m_codType) && !"trial".equals(this.m_codType)) {
                    String[] stringArray = new String[]{"-c"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            } else if (!(this.m_codType != null && ("onoff".equals(this.m_codType) || "cuod".equals(this.m_codType) || "reserve".equals(this.m_codType) || "trialexc".equals(this.m_codType) || "trialstd".equals(this.m_codType)))) {
                String[] stringArray = new String[]{"-c"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            string = "";
            if (!"reserve".equals(this.m_codType)) {
                if (this.m_resourceType == null || !"mem".equals(this.m_resourceType) && !"proc".equals(this.m_resourceType)) {
                    String[] stringArray = new String[]{"-r"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            } else if (this.m_resourceType == null || !"proc".equals(this.m_resourceType)) {
                String[] stringArray = new String[]{"-r"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        } else if (LIST_BILLING.equals(this.m_listType)) {
            string = "";
            if (this.m_resourceType == null || !"mem".equals(this.m_resourceType) && !"proc".equals(this.m_resourceType)) {
                string = string + ", -r";
            }
            if (this.m_codType != null && !"onoff".equals(this.m_codType)) {
                string = string + ", -c";
            }
            if (string.length() > 0) {
                if (string.startsWith(", ")) {
                    string = string.substring(2, string.length());
                }
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        } else if (LIST_UTILIZATION.equals(this.m_listType)) {
            string = "";
            if (this.m_resourceType == null || !"proc".equals(this.m_resourceType)) {
                string = string + ", -r";
            }
            if (this.m_codType != null && !"reserve".equals(this.m_codType)) {
                string = string + ", -c";
            }
            if (string.length() > 0) {
                if (string.startsWith(", ")) {
                    string = string.substring(2, string.length());
                }
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        } else {
            string = "";
            if (this.m_resourceType != null) {
                string = string + ", -r";
            }
            if (this.m_codType != null) {
                string = string + ", -c";
            }
            if (string.length() > 0) {
                if (string.startsWith(", ")) {
                    string = string.substring(2, string.length());
                }
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
            }
        }
        if (this.m_header && this.m_format == null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
        }
        if (this.m_all && !LIST_BILLING.equals(this.m_listType)) {
            String[] stringArray = new String[]{"--all"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_codType = (String)hashMap.get("-c");
        this.m_listType = (String)hashMap.get("-t");
        this.m_format = (String)hashMap.get("-F");
        String string = (String)hashMap.get("--header");
        this.m_header = string != null;
        String string2 = (String)hashMap.get("--all");
        this.m_all = string2 != null;
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSCOD_HELP_2"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PICodList pICodList = new PICodList(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pICodList.m_validParms);
            pICodList.mapParameters(hashMap);
            pICodList.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

